100BA: SAT-Based Solver for Assumption-Based Argumentation
==========================================================

Contents
--------
- `acyc`: Implementation of 100BA-acyc (SAT with acyclicity propagator)
- `ufs`: Implementation of 100BA-ufs (SAT with unfounded set propagator)
- `ve`: Implementation of 100BA-ve (SAT encoding using vertex elimination for acyclicity)
- `lib`: Source code of CaDiCaL (version 2.1.3)

Build
-----

1. Compile CaDiCaL by issuing `./configure` and `make` in `./lib/cadical-2.1.3`.
2. In all of the directories `./acyc`, `./ufs`, `./ve`, issue `make r`.
3. The solver will be available under `./<dir>/build/release/bin/100BA` where `<dir>` is `acyc`, `ufs`, or `ve`.

Usage
-----

All solvers are used from the command line as follows:
```
./<dir>/build/release/bin/aba2sat -p <task> -f <file> -fo <format> [-a <query>]

  <task>      computational problem; for a list of available problems use option --problems
  <file>      input assumption-based argumentation framework (ABA)
  <format>    file format for input ABA; for a list of available formats use option --formats
  <query>     query argument

Options:
  --help      Displays this help message.
  --version   Prints version and author information.
  --formats   Prints available file formats.
  --problems  Prints available computational tasks.
```

The available file format `<format>` is `i23` (ICCMA23 file format, see `http://argumentationcompetition.org/2023/rules.html` for a description), which is the default option. Note that `apx` is not supported in this release.

The available computational problems are the following: DC-AD, DC-CO, DC-PR, DC-ST, DC-SST, DC-STG, DC-ID, DS-AD, DS-CO, DS-PR, DS-ST, DS-SST, DS-STG, DS-ID, SE-AD, SE-CO, SE-PR, SE-ST, SE-SST, SE-STG, SE-ID, EE-AD, EE-CO, EE-PR, EE-ST, EE-SST, EE-STG, EE-ID
