#ifndef ASSUMPTION_BASED_FRAMEWORK_H
#define ASSUMPTION_BASED_FRAMEWORK_H

#include <vector>
#include <stack>
#include <unordered_map>
#include <string>
#include <boost/container_hash/hash.hpp>

typedef boost::hash<std::vector<uint32_t>>        vector_hash;
typedef boost::hash<std::pair<uint32_t,uint32_t>> pair_hash;

enum task { DC, DS, SE, EE, UNKNOWN_TASK };
enum semantics { AD, CO, PR, ST, SST, STG, ID, UNKNOWN_SEM };
enum var_type {
  in,
  out,
  attacked_by_undec,
  body_is_true_in,
  body_is_true_undec,
  derived_from_in,
  derived_from_undec,
  range,
  none
};

class ABF {
public:

ABF();

semantics sem;

uint32_t symbols;
int count;
uint32_t upper_bound;
bool symbols_as_strings;

std::vector<std::pair<int,int>> derivation_edges; // list of edges
std::vector<std::vector<int>>   derivation_graph; // adjacency list
std::vector<std::vector<int>>   derivation_graph_rev; // reverse adjacency list

uint32_t scc_count;
std::vector<uint32_t> scc_index;

std::unordered_map<uint32_t,std::string> int_to_symbol;
std::unordered_map<std::string,uint32_t> symbol_to_int;

std::vector<std::pair<uint32_t,uint32_t>> rules; // head, body index
std::vector<std::vector<uint32_t>> bodies; // unique bodies
std::unordered_map<std::vector<uint32_t>,uint32_t,vector_hash> body_index;
std::vector<uint32_t> assumptions;
std::unordered_map<uint32_t,uint32_t> contrary;

std::unordered_map<uint32_t,std::vector<uint32_t>> rules_with_head;
std::unordered_map<uint32_t,std::vector<uint32_t>> bodies_with_head;
std::unordered_map<uint32_t,uint8_t> is_assumption;

std::vector<int> in_var;
std::vector<int> out_var;
std::vector<int> attacked_by_undec_var;
std::vector<int> range_var;

std::vector<int> body_is_true_in_var;
std::vector<int> body_is_true_undec_var;

std::vector<int> rule_is_justified_in_var;
std::vector<int> rule_is_justified_undec_var;

std::vector<int> derived_from_in_var;
std::vector<int> derived_from_undec_var;

std::unordered_map<std::pair<uint32_t,uint32_t>,int,pair_hash> derived_from_in_edge_var;
std::unordered_map<std::pair<uint32_t,uint32_t>,int,pair_hash> derived_from_undec_edge_var;

int min_edge_var;
int max_edge_var;

std::vector<std::pair<var_type,uint32_t>> interpretation;

void add_rule(std::vector<uint32_t> & rule);
void add_assumption(uint32_t assum);
void add_contrary(uint32_t assum, uint32_t cont);

void add_rule(std::string rule);
void add_assumption(std::string assum);
void add_contrary(std::string assum, std::string cont);

void initialize_vars();
std::string lit_to_string(int lit);

private:

void strong_connect(uint32_t node, uint32_t & index,
  std::stack<uint32_t> & node_stack, std::vector<uint8_t> & on_stack,
  std::vector<uint32_t> & node_to_index, std::vector<uint32_t> & node_to_lowlink);
void tarjan_scc();

};

#endif
