#ifndef PROPAGATOR_H
#define PROPAGATOR_H

#include <vector>
#include <set>
#include <stack>
#include <queue>
#include <deque>
#include <unordered_map>

#include "cadical.hpp"
#include "ABF.h"

enum ArcStatus {
    POSSIBLE = 0,
    ENABLED = 1,
    DISABLED = 2,
};

struct Graph {

    Graph(std::vector<int> & arc_vars, std::vector<std::pair<int,int>> & arcs);
    void add_arc(int arc_var, int source, int target);
    void bfs(int source, bool reverse, std::vector<uint8_t> & reachable, std::vector<int> & path);
    void dfs(int source, bool reverse, std::vector<uint8_t> & reachable, std::vector<int> & path);
    void append_path_to_clause(int source, int target, bool reverse, std::vector<int> & path, std::vector<int> & clause);

    int n_nodes;
    //inline size_t key(int s, int t) { return (size_t) (s-1)*n_nodes+t-1; }
    inline size_t key(int s, int t) { return (size_t) s*n_nodes+t; }

    std::set<int> nodes;
    std::set<std::pair<int,int>> arcs;

    std::unordered_map<int,std::pair<int,int>> var_to_arc;
    std::vector<int> arc_to_var;
    std::vector<ArcStatus> arc_to_status;

    std::vector<std::vector<int>> adjacency_list;
    std::vector<std::vector<int>> reverse_adjacency_list;

};

class AcyclicityPropagator : public CaDiCaL::ExternalPropagator, public CaDiCaL::FixedAssignmentListener {

public:
    AcyclicityPropagator(ABF & af, Graph & graph);
    ~AcyclicityPropagator();

    void notify_fixed_assignment (int lit);
    void notify_assignment (const std::vector<int> &lits);
    //void notify_assignment(int lit, bool is_fixed);
    void notify_new_decision_level();
    void notify_backtrack(size_t new_level);

    bool cb_check_found_model(const std::vector<int> &model);
    int cb_decide() { return 0; };
    int cb_propagate();
    int cb_add_reason_clause_lit(int propagated_lit);
    bool cb_has_external_clause(bool &is_forgettable);
    //bool cb_has_external_clause();
    int cb_add_external_clause_lit();

private:
    ABF & af;
    Graph & graph;

    bool trail_changed;
    std::deque<std::vector<int>> trail;
    std::unordered_map<int,std::vector<int>> reasons;
    std::deque<std::vector<int>> clauses;
    std::vector<uint8_t> is_fixed;
    std::deque<std::pair<int,int>> assignments;

    double propagate_time;

    void propagate();
};

#endif