#ifndef UTIL_H
#define UTIL_H

#include <iostream>
#include <vector>

#include "cadical.hpp"
typedef CaDiCaL::Solver SAT_Solver;

#include "ABF.h"

void add_clause(SAT_Solver * solver, std::vector<int> & clause);
void assume_all(SAT_Solver * solver, std::vector<int> & assumptions);

void print_begin(bool new_line);
void print_end(bool new_line);

void print_yes(bool comma);
void print_no(bool comma);

void print_single_extension(ABF & abf, std::vector<uint32_t> & extension, bool tab);
void print_extensions(ABF & abf, std::vector<std::vector<uint32_t>> & extensions);

#endif
