#include "Util.h"

using namespace std;

void add_clause(SAT_Solver * solver, std::vector<int> & clause) {
    for (int lit : clause) {
        solver->add(lit);
#if defined(OUTPUT)
        cout << lit << " ";
#endif
    }
    solver->add(0);
#if defined(OUTPUT)
    cout << "0" << endl;
#endif
}

void assume_all(SAT_Solver * solver, std::vector<int> & assumptions) {
    for (int lit : assumptions) {
        solver->assume(lit);
    }
}

void print_begin(bool new_line)
{
	string bracket = "[";
	if (new_line) bracket += "\n";
	cout << bracket << flush;
}

void print_end(bool new_line)
{
	string bracket = "]";
	if (new_line) bracket += "\n";
	cout << bracket << flush;
}

void print_yes(bool comma)
{
	string answer = "YES";
	if (comma) answer += ", ";
	cout << answer << flush;
}

void print_no(bool comma)
{
	string answer = "NO";
	if (comma) answer += ", ";
	cout << answer << flush;
}

void print_single_extension(ABF & af, std::vector<uint32_t> & extension, bool tab)
{
	if (af.symbols_as_strings) { // APX format
		if (tab) cout << "\t";
		cout << "[";
		for (uint32_t i = 0; i < extension.size(); i++) {
			cout << af.int_to_symbol[extension[i]];
			if (i != extension.size()-1) cout << ",";
		}
		cout << "]" << endl;
	} else { // ICCMA'23 format
		cout << "w ";
		for (uint32_t i = 0; i < extension.size(); i++) {
			cout << extension[i];
			if (i != extension.size()-1) cout << " ";
		}
		cout << endl;
	}
}

void print_extensions(ABF & af, std::vector<std::vector<uint32_t>> & extensions)
{
	if (af.symbols_as_strings) { // APX format
		cout << "\t[\n";
		for (uint32_t i = 0; i < extensions.size(); i++) {
			cout << "\t\t[";
			for (uint32_t j = 0; j < extensions[i].size(); j++) {
				if (af.symbols_as_strings)
					cout << af.int_to_symbol[extensions[i][j]];
				else
					cout << extensions[i][j];
				if (j != extensions[i].size()-1) cout << ",";
			}
			cout << "]" << "\n";
		}
		cout << "\t]" << endl;
	} else {
		for (uint32_t i = 0; i < extensions.size(); i++) {
			cout << "w ";
			for (uint32_t j = 0; j < extensions[i].size(); j++) {
				cout << extensions[i][j];
				if (j != extensions[i].size()-1) cout << " ";
			}
			cout << endl;
		}
	}
}
