#ifndef PROPAGATOR_H
#define PROPAGATOR_H

#include <vector>
#include <queue>
#include <deque>
#include <list>
#include <unordered_set>
#include <unordered_map>

#include "cadical.hpp"
#include "ABF.h"

//class UnfoundedSetPropagator : public CaDiCaL::ExternalPropagator {
class UnfoundedSetPropagator : public CaDiCaL::ExternalPropagator, public CaDiCaL::FixedAssignmentListener {

public:
    UnfoundedSetPropagator(ABF & af, CaDiCaL::Solver * solver);
    ~UnfoundedSetPropagator();
    void init();

    void notify_fixed_assignment (int lit);
    void notify_assignment (const std::vector<int> &lits);
    //void notify_assignment(int lit, bool is_fixed);
    void notify_new_decision_level();
    void notify_backtrack(size_t new_level);

    bool cb_check_found_model(const std::vector<int> &model);
    int cb_decide() { return 0; };
    int cb_propagate();
    int cb_add_reason_clause_lit(int propagated_lit);
    bool cb_has_external_clause(bool &is_forgettable);
    //bool cb_has_external_clause();
    int cb_add_external_clause_lit();

private:
    ABF & af;
    CaDiCaL::Solver * solver;

    std::vector<int8_t>   atom_assignment[2];
    std::vector<uint8_t>  source_valid[2];
    std::vector<uint32_t> source_pointer[2];
    std::vector<uint8_t>  is_todo[2];
    std::vector<uint8_t>  is_unfounded[2];

    std::vector<int8_t>   body_assignment[2];
    std::vector<uint32_t> body_count[2];
    std::vector<uint32_t> body_watches[2];

    std::queue<uint32_t>  source_queue[2];
    std::queue<uint32_t>  invalid_queue[2];
    std::queue<uint32_t>  todo_queue[2];
    std::list<uint32_t>   ufs_list[2];
 
    std::unordered_set<uint32_t> external_bodies;

    bool trail_changed;
    std::deque<std::vector<int>> trail;
    std::unordered_map<int,std::vector<int>> reasons;
    std::deque<std::vector<int>> clauses;
    std::vector<uint8_t> is_fixed;

    double propagate_time;

    void print_set(std::vector<uint8_t> & v);
    void push_ufs(uint8_t index, uint32_t atom)  {
        if (!is_unfounded[index][atom]) {
            is_unfounded[index][atom] = 1;
            ufs_list[index].push_back(atom);
        }
    }
    void push_todo(uint8_t index, uint32_t atom) {
        if (!is_todo[index][atom]) {
            is_todo[index][atom] = 1;
            todo_queue[index].push(atom);
        }
    }

    void set_source(uint8_t index, uint32_t body_index, uint32_t head);
    void propagate_source_pointers(uint8_t index);
    void find_source(uint8_t index, uint32_t head);
    void get_external_bodies(uint8_t index);
    void add_loop_formula(uint8_t index, uint32_t head);
    void propagate(uint8_t index);

    void assign(int var, int8_t val);
    int8_t value(int var);

};

#endif
