#include "Encodings.h"
#include "Util.h"
#include "SkeptAcceptance.h"

using namespace std;

namespace SkeptAcceptance {

bool admissible(ABF & af, uint32_t query, SAT_Solver * solver)
{
	if (af.is_assumption[query]) {
		solver->add(-af.in_var[query]); solver->add(0);
	} else {
		solver->add(-af.derived_from_in_var[query]); solver->add(0);
	}
	Encodings::add_admissible(af, solver);
	int sat = solver->solve();
	return sat == 20;
}

bool complete(ABF & af, uint32_t query, SAT_Solver * solver)
{
	if (af.is_assumption[query]) {
		solver->add(-af.in_var[query]); solver->add(0);
	} else {
		solver->add(-af.derived_from_in_var[query]); solver->add(0);
	}
	Encodings::add_complete(af, solver);
	int sat = solver->solve();
	return sat == 20;
}

bool preferred(ABF & af, uint32_t query, SAT_Solver * solver)
{
	Encodings::add_complete(af, solver);
	/*for (uint32_t i = 0; i < af.assumptions.size(); i++) {
		solver->phase(af.in_var[af.assumptions[i]]);
	}*/

	vector<int> assumptions;
	if (af.is_assumption[query]) {
		assumptions.push_back(-af.in_var[query]);
	} else {
		assumptions.push_back(-af.derived_from_in_var[query]);
	}

	while (true) {
		assume_all(solver, assumptions);
		int sat = solver->solve();
		if (sat == 20) break;

		vector<int> complement_clause;
		complement_clause.reserve(af.assumptions.size());
		vector<uint8_t> visited(af.assumptions.size());
		vector<int> new_assumptions = assumptions;
		new_assumptions.reserve(af.assumptions.size());

		while (true) {
			complement_clause.clear();
			for (uint32_t i = 0; i < af.assumptions.size(); i++) {
				if (solver->val(af.in_var[af.assumptions[i]]) > 0) {
					if (!visited[i]) {
						new_assumptions.push_back(af.in_var[af.assumptions[i]]);
						visited[i] = 1;
					}
				} else {
					complement_clause.push_back(af.in_var[af.assumptions[i]]);
				}
			}
			add_clause(solver, complement_clause);
			assume_all(solver, new_assumptions);
			int superset_exists = solver->solve();
			if (superset_exists == 20) break;
		}

		new_assumptions[0] = -new_assumptions[0];
		assume_all(solver, new_assumptions);

		if (solver->solve() == 20) {
			return false;
		}
	}
	return true;
}

bool stable(ABF & af, uint32_t query, SAT_Solver * solver)
{
	if (af.is_assumption[query]) {
		solver->add(-af.in_var[query]); solver->add(0);
	} else {
		solver->add(-af.derived_from_in_var[query]); solver->add(0);
	}
	Encodings::add_stable(af, solver);
	int sat = solver->solve();
	return sat == 20;
}

bool semi_stable(ABF & af, uint32_t query, SAT_Solver * solver)
{
	Encodings::add_complete(af, solver);
	Encodings::add_range(af, solver);

	vector<int> assumptions;
	if (af.is_assumption[query]) {
		assumptions.push_back(-af.in_var[query]);
	} else {
		assumptions.push_back(-af.derived_from_in_var[query]);
	}

	while (true) {
		assume_all(solver, assumptions);
		int sat = solver->solve();
		if (sat == 20) break;

		vector<int> complement_clause;
		complement_clause.reserve(af.assumptions.size());
		vector<uint8_t> visited(af.assumptions.size());
		vector<int> new_assumptions = assumptions;
		new_assumptions.reserve(af.assumptions.size());

		while (true) {
			complement_clause.clear();
			for (uint32_t i = 0; i < af.assumptions.size(); i++) {
				if (solver->val(af.range_var[af.assumptions[i]]) > 0) {
					if (!visited[i]) {
						new_assumptions.push_back(af.range_var[af.assumptions[i]]);
						visited[i] = 1;
					}
				} else {
					complement_clause.push_back(af.range_var[af.assumptions[i]]);
				}
			}
			add_clause(solver, complement_clause);
			assume_all(solver, new_assumptions);
			int superset_exists = solver->solve();
			if (superset_exists == 20) break;
		}

		new_assumptions[0] = -new_assumptions[0];
		assume_all(solver, new_assumptions);

		if (solver->solve() == 20) {
			return false;
		}
	}
	return true;
}

bool stage(ABF & af, uint32_t query, SAT_Solver * solver)
{
	Encodings::add_conflict_free(af, solver);
	Encodings::add_range(af, solver);

	vector<int> assumptions;
	if (af.is_assumption[query]) {
		assumptions.push_back(-af.in_var[query]);
	} else {
		assumptions.push_back(-af.derived_from_in_var[query]);
	}

	while (true) {
		assume_all(solver, assumptions);
		int sat = solver->solve();
		if (sat == 20) break;

		vector<int> complement_clause;
		complement_clause.reserve(af.assumptions.size());
		vector<uint8_t> visited(af.assumptions.size());
		vector<int> new_assumptions = assumptions;
		new_assumptions.reserve(af.assumptions.size());

		while (true) {
			complement_clause.clear();
			for (uint32_t i = 0; i < af.assumptions.size(); i++) {
				if (solver->val(af.range_var[af.assumptions[i]]) > 0) {
					if (!visited[i]) {
						new_assumptions.push_back(af.range_var[af.assumptions[i]]);
						visited[i] = 1;
					}
				} else {
					complement_clause.push_back(af.range_var[af.assumptions[i]]);
				}
			}
			add_clause(solver, complement_clause);
			assume_all(solver, new_assumptions);
			int superset_exists = solver->solve();
			if (superset_exists == 20) break;
		}

		new_assumptions[0] = -new_assumptions[0];
		assume_all(solver, new_assumptions);

		if (solver->solve() == 20) {
			return false;
		}
	}
	return true;
}

}
