#include "Encodings.h"
#include "Util.h"
#include "EnumerateExtensions.h"

using namespace std;

namespace EnumerateExtensions {

bool admissible(ABF & af, SAT_Solver * solver)
{
#if defined(OUTPUT)
	return false;
#endif
	Encodings::add_admissible(af, solver);
	if (af.symbols_as_strings) print_begin(true);
	while (true) {
		int sat = solver->solve();
		if (sat == 20) break;
		vector<uint32_t> extension;
		vector<int> blocking_clause(af.assumptions.size());
		for (uint32_t i = 0; i < af.assumptions.size(); i++) {
			if (solver->val(af.in_var[af.assumptions[i]]) > 0) {
				extension.push_back(af.assumptions[i]+1);
				blocking_clause[i] = -af.in_var[af.assumptions[i]];
			} else {
				blocking_clause[i] = af.in_var[af.assumptions[i]];
			}
		}
		print_single_extension(af, extension, 1);
		add_clause(solver, blocking_clause);
	}
	if (af.symbols_as_strings) print_end(true);
	return true;
}

bool complete(ABF & af, SAT_Solver * solver)
{
#if defined(OUTPUT)
	return false;
#endif
	Encodings::add_complete(af, solver);
	if (af.symbols_as_strings) print_begin(true);
	while (true) {
		int sat = solver->solve();
		if (sat == 20) break;
		vector<uint32_t> extension;
		vector<int> blocking_clause(af.assumptions.size());
		for (uint32_t i = 0; i < af.assumptions.size(); i++) {
			if (solver->val(af.in_var[af.assumptions[i]]) > 0) {
				extension.push_back(af.assumptions[i]+1);
				blocking_clause[i] = -af.in_var[af.assumptions[i]];
			} else {
				blocking_clause[i] = af.in_var[af.assumptions[i]];
			}
		}
		print_single_extension(af, extension, 1);
		add_clause(solver, blocking_clause);
	}
	if (af.symbols_as_strings) print_end(true);
	return true;
}

bool preferred(ABF & af, SAT_Solver * solver)
{
#if defined(OUTPUT)
	return false;
#endif
	Encodings::add_complete(af, solver);
	/*for (uint32_t i = 0; i < af.assumptions.size(); i++) {
		solver->phase(af.in_var[af.assumptions[i]]);
	}*/

	if (af.symbols_as_strings) print_begin(true);
	while (true) {
		int sat = solver->solve();
		if (sat == 20) break;
		vector<int> complement_clause;
		complement_clause.reserve(af.assumptions.size());
		vector<int> assumptions;
		assumptions.reserve(af.assumptions.size());
		vector<uint8_t> visited;
		visited.resize(af.assumptions.size());
		while (true) {
			complement_clause.clear();
			for (uint32_t i = 0; i < af.assumptions.size(); i++) {
				if (solver->val(af.in_var[af.assumptions[i]]) > 0) {
					if (!visited[i]) {
						assumptions.push_back(af.in_var[af.assumptions[i]]);
						visited[i] = true;
					}
				} else {
					complement_clause.push_back(af.in_var[af.assumptions[i]]);
				}
			}
			add_clause(solver, complement_clause);
			assume_all(solver, assumptions);
			int superset = solver->solve();
			if (superset == 20) break;
		}
		vector<uint32_t> extension;
		for (uint32_t i = 0; i < af.assumptions.size(); i++) {
			if (visited[i]) {
				extension.push_back(af.assumptions[i]+1);
			}
		}
		print_single_extension(af, extension, 1);
	}
	if (af.symbols_as_strings) print_end(true);
	return true;
}

bool stable(ABF & af, SAT_Solver * solver)
{
#if defined(OUTPUT)
	return false;
#endif
	Encodings::add_stable(af, solver);
	bool extension_found = false;
	while (true) {
		int sat = solver->solve();
		if (sat == 20) break;
		if (!extension_found) {
			if (af.symbols_as_strings) print_begin(true);
			extension_found = true;
		}
		vector<uint32_t> extension;
		vector<int> blocking_clause(af.assumptions.size());
		for (uint32_t i = 0; i < af.assumptions.size(); i++) {
			if (solver->val(af.in_var[af.assumptions[i]]) > 0) {
				extension.push_back(af.assumptions[i]+1);
				blocking_clause[i] = -af.in_var[af.assumptions[i]];
			} else {
				blocking_clause[i] = af.in_var[af.assumptions[i]];
			}
		}
		print_single_extension(af, extension, 1);
		add_clause(solver, blocking_clause);
	}
	if (af.symbols_as_strings && !extension_found) print_begin(false);
	if (af.symbols_as_strings) print_end(true);
	return extension_found;
}

bool semi_stable(ABF & af, SAT_Solver * solver)
{
#if defined(OUTPUT)
	return false;
#endif
	Encodings::add_complete(af, solver);
	Encodings::add_range(af, solver);

	SAT_Solver * range_solver = new SAT_Solver();

	Encodings::add_complete(af, range_solver);
	Encodings::add_range(af, range_solver);

	if (af.symbols_as_strings) print_begin(true);
	while (true) {
		int sat = solver->solve();
		if (sat == 20) break;
		vector<int> complement_clause;
		complement_clause.reserve(af.assumptions.size());
		vector<int> assumptions;
		assumptions.reserve(af.assumptions.size());
		vector<uint8_t> visited;
		visited.resize(af.assumptions.size());
		while (true) {
			complement_clause.clear();
			for (uint32_t i = 0; i < af.assumptions.size(); i++) {
				if (solver->val(af.range_var[af.assumptions[i]]) > 0) {
					if (!visited[i]) {
						assumptions.push_back(af.range_var[af.assumptions[i]]);
						visited[i] = true;
					}
				} else {
					complement_clause.push_back(af.range_var[af.assumptions[i]]);
				}
			}
			add_clause(solver, complement_clause);
			assume_all(solver, assumptions);
			int superset = solver->solve();
			if (superset == 20) break;
		}

		assumptions.clear();
		assumptions.resize(af.assumptions.size());
		for (uint32_t i = 0; i < af.assumptions.size(); i++) {
			if (visited[i]) {
				assumptions[i] = af.range_var[af.assumptions[i]];
			} else {
				assumptions[i] = -af.range_var[af.assumptions[i]];
			}
		}

		while (true) {
			assume_all(range_solver, assumptions);
			int sat = range_solver->solve();
			if (sat == 20) break;
			vector<uint32_t> extension;
			vector<int> blocking_clause;
			blocking_clause.reserve(af.assumptions.size());
			for (uint32_t i = 0; i < af.assumptions.size(); i++) {
				if (range_solver->val(af.in_var[af.assumptions[i]]) > 0) {
					extension.push_back(af.assumptions[i]+1);
					blocking_clause.push_back(-af.in_var[af.assumptions[i]]);
				} else {
					blocking_clause.push_back(af.in_var[af.assumptions[i]]);
				}
			}
			print_single_extension(af, extension, 1);
			add_clause(range_solver, blocking_clause);
		}
	}
	delete range_solver;
	if (af.symbols_as_strings) print_end(true);
	return true;
}

bool stage(ABF & af, SAT_Solver * solver)
{
#if defined(OUTPUT)
	return false;
#endif

	Encodings::add_conflict_free(af, solver);
	Encodings::add_range(af, solver);

	SAT_Solver * range_solver = new SAT_Solver();

	Encodings::add_conflict_free(af, range_solver);
	Encodings::add_range(af, range_solver);

	if (af.symbols_as_strings) print_begin(true);
	while (true) {
		int sat = solver->solve();
		if (sat == 20) break;
		vector<int> complement_clause;
		complement_clause.reserve(af.assumptions.size());
		vector<int> assumptions;
		assumptions.reserve(af.assumptions.size());
		vector<uint8_t> visited;
		visited.resize(af.assumptions.size());
		while (true) {
			complement_clause.clear();
			for (uint32_t i = 0; i < af.assumptions.size(); i++) {
				if (solver->val(af.range_var[af.assumptions[i]]) > 0) {
					if (!visited[i]) {
						assumptions.push_back(af.range_var[af.assumptions[i]]);
						visited[i] = true;
					}
				} else {
					complement_clause.push_back(af.range_var[af.assumptions[i]]);
				}
			}
			add_clause(solver, complement_clause);
			assume_all(solver, assumptions);
			int superset = solver->solve();
			if (superset == 20) break;
		}

		assumptions.clear();
		assumptions.resize(af.assumptions.size());
		for (uint32_t i = 0; i < af.assumptions.size(); i++) {
			if (visited[i]) {
				assumptions[i] = af.range_var[af.assumptions[i]];
			} else {
				assumptions[i] = -af.range_var[af.assumptions[i]];
			}
		}

		while (true) {
			assume_all(range_solver, assumptions);
			int sat = range_solver->solve();
			if (sat == 20) break;
			vector<uint32_t> extension;
			vector<int> blocking_clause;
			blocking_clause.reserve(af.assumptions.size());
			for (uint32_t i = 0; i < af.assumptions.size(); i++) {
				if (range_solver->val(af.in_var[af.assumptions[i]]) > 0) {
					extension.push_back(af.assumptions[i]+1);
					blocking_clause.push_back(-af.in_var[af.assumptions[i]]);
				} else {
					blocking_clause.push_back(af.in_var[af.assumptions[i]]);
				}
			}
			print_single_extension(af, extension, 1);
			add_clause(range_solver, blocking_clause);
		}
	}
	delete range_solver;
	if (af.symbols_as_strings) print_end(true);
	return true;
}

}
