# SMART Solver

SMART (version 1.0) is a solver for abstract argumention frameworks that supports multiple decision problems in computational argumentation, developed by Sandra Hoffmann, Isabelle Kuhlmann, and Matthias Thimm.

## Description

SMART is a Python-based solver that works with abstract argumentation frameworks. It can handle various computational problems related to argumentation semantics, particularly focused on preferred, complete, and grounded extensions. The solver implements backtracking algorithms and machine learning predictions as heuristics to efficiently determine if an argument is in a accepted given a semantics.

## Features

- Solves decision problems in computational argumentation:
  - DC-CO: Credulous acceptance under complete semantics
  - DC-GR: Credulous acceptance under grounded semantics
  - SE-GR: Enumerate the grounded extension
  - DC-PR: Credulous acceptance under preferred semantics
- Supports input formats: i23, apx

## Installation

### Requirements

- Python 3
- Dependencies: 
  - natsort
  - sortedcontainers
  - networkx
  - pandas
  - numpy
  - torch
  - torch-geometric


### Installation Steps

1. Clone this repository
2. Install required dependencies:
```
pip install torch
pip install torch-scatter torch-sparse torch-geometric -f https://data.pyg.org/whl/torch-2.1.0+cpu.html
pip install natsort sortedcontainers networkx pandas numpy
```

## Usage

```
python3 smart.py -p <problem> -f <file_path> -a <query_argument>
```

### Basic Options

- `-p`: The problem to solve (required). Choose from: DC-CO, DC-GR, SE-GR, DC-PR
- `-f`: Path to the argumentation framework file (required)
- `-a`: The query argument to check (required for DC problems)

### Additional Options

- `--problems`: List all supported problems
- `--formats`: List all supported input formats

### Example Usage

```
# Check if argument a1 is credulously accepted under preferred semantics
python3 smart.py -p DC-PR -f examples/framework.apx -a a1

# Check if argument a2 is in the grounded extension
python3 smart.py -p DC-GR -f examples/framework.apx -a a2

# Output the grounded extension of a framework
python3 smart.py -p SE-GR -f examples/framework.apx
```

## Output Format

- For decision problems (DC-): "YES" or "NO", followed by a witness extension for positive answers
- For SE-GR: The grounded extension formatted as "[arg1, arg2, ...]"

### Witness Format

For positive answers to decision problems, the solver outputs a witness extension in the format:
```
w arg1 arg2 arg3 ...
```
where arguments are sorted in natural order.

## Analytics

The solver can collect performance analytics during execution. Analytics are saved to a CSV file in the `analytics/<run_name>/` subdirectory where the input file is located.

Analytics tracked include:
- Runtime for different phases (parsing, optimization checks, prediction, heuristic, solving)
- Number of backtracks during solving
- Prediction and heuristic information
- Overall performance time

## Contributors

- Sandra Hoffmann <sandra.hoffmann@fernuni-hagen.de>
- Isabelle Kuhlmann <isabelle.kuhlmann@fernuni-hagen.de>
- Matthias Thimm <matthias.thimm@fernuni-hagen.de>

## License

MIT License

Copyright (c) 2025 Sandra Hoffmann, Isabelle Kuhlmann, Matthias Thimm

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.