import copy
from sortedcontainers import SortedSet



class Labelling:
    def __init__(self, af):
        self.MUST_IN = SortedSet()
        self.MUST_UNDEC = SortedSet()
        self.label_dict = {}
        for key in af.arguments.keys():
            self.label_dict[key] = {
                'BLANK': 0,
                'UNDEC': 0,
                'label': 'blank'
            }

    def copy(self):
        return copy.deepcopy(self)

    def set_label(self, arg, label):
        def handle_must_in():
            self.label_dict[arg]['label'] = 'must_in'
            self.MUST_IN.add(arg)

        def handle_must_undec():
            self.label_dict[arg]['label'] = 'must_undec'
            self.MUST_UNDEC.add(arg)

        handlers = {
            'must_in': handle_must_in,
            'must_undec': handle_must_undec,
        }

        handler = handlers.get(label)
        if handler:
            handler()
        else:
            raise ValueError(f"Unknown label: {label}")


    def create_BLANK_mapping(self, af, argument):
        """
        BLANK maps an argument to the number of attackers that are labeled blank, must_in or must_undec
        """
        self.label_dict[argument]['BLANK'] = sum(
            1 for attacker in af.arguments[argument]['predecessors']
            if self.label_dict[attacker]['label'] in {'blank', 'must_in', 'must_undec'}
        )


    def create_UNDEC_mapping(self, af, argument):
        """
        UNDEC maps an argument to the number of undec attackers
        """
        self.label_dict[argument]['UNDEC'] = sum(
            1 for attacker in af.arguments[argument]['predecessors']
            if self.label_dict[attacker]['label'] == 'undec'
        )
