/*!
 * Copyright (c) <2020> <Andreas Niskanen, University of Helsinki>
 * 
 * 
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * 
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * 
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef CRED_ACCEPTANCE_H
#define CRED_ACCEPTANCE_H

#include "AF.h"

namespace CredAcceptance {

bool complete(const AF & af, const std::vector<std::string> & queries);
bool stable(const AF & af, const std::vector<std::string> & queries);
bool complete(const AF & af, const std::string & arg);
bool preferred(const AF & af, const std::string & arg);
bool stable(const AF & af, const std::string & arg);
bool grounded(const AF & af, const std::string & arg);
bool semi_stable(const AF & af, const std::string & arg);
bool stage(const AF & af, const std::string & arg);
bool ideal(const AF & af, const std::string & arg);

}

#endif
