/* ============================================================================================================== */
/* == BEGIN FILE ================================================================================================ */
/* ============================================================================================================== */
/*
 ============================================================================
 Name        : taas_problem.h
 Author      : Matthias Thimm and Paul Cibier
 Version     : 1.0
 Copyright   : GPL3
============================================================================
*/
#pragma once

#include <string>
#include <vector>

using namespace std;
/* ============================================================================================================== */
namespace taas{

  enum Problem{
    DS_GR = 1,
    DC_GR = 2,
    SE_GR = 3,
    EE_GR = 4,
    DS_CO = 5,
    DC_CO = 6,
    SE_CO = 7,
    EE_CO = 8,
    DS_PR = 9,
    DC_PR = 10,
    SE_PR = 11,
    EE_PR = 12,
    DS_ST = 13,
    DC_ST = 14,
    SE_ST = 15,
    EE_ST = 16,
    DS_SST = 17,
    DC_SST = 18,
    SE_SST = 19,
    EE_SST = 20,
    DS_STG = 21,
    DC_STG = 22,
    SE_STG = 23,
    EE_STG = 24,
    DS_ID = 25,
    DC_ID = 26,
    SE_ID = 27,
    EE_ID = 28
  };

  Problem string_to_problem(string problem);
  string problem_to_string(Problem problem);
  string problems_to_string(vector<Problem> problems);
  bool is_decision_problem(Problem problem);
}
/* ============================================================================================================== */
/* == END FILE ================================================================================================== */
/* ============================================================================================================== */
