/* ============================================================================================================== */
/* == BEGIN FILE ================================================================================================ */
/* ============================================================================================================== */
/*
 ============================================================================
 Name        : miscutil.c
 Author      : Matthias Thimm
 Version     : 2.0
 Copyright   : GPL3
 Description : Misc utility structures and functions.
 ============================================================================
 */

 /**
 * A simple string value pair.
 */
struct StringValuePair{
	char* string;
	int value;
};

/** Util function for trimming white space */
char *trimwhitespace(char *str){
  char *end;
  // Trim leading space
  while(isspace(*str)) str++;
  if(*str == 0)  // All spaces?
    return str;
  // Trim trailing space
  end = str + strlen(str) - 1;
  while(end > str && isspace(*end)) end--;
  // Write new null terminator
  *(end+1) = 0;
  return str;
}
/* ============================================================================================================== */
/* == END FILE ================================================================================================== */
/* ============================================================================================================== */
