# Scallop at ICCMA 2025

Scallop is entering the competition in the main, ABA, dynamic, and heuristics tracks.
It also participates in the fixed-SAT solver comparison.
See below for instructions on how to compile and use Scallop.


## Prerequisites

Scallop requires a recent version of the Rust toolchain.
Visit the dedicated page if you need to install Rust: [https://www.rust-lang.org/tools/install](https://www.rust-lang.org/tools/install).


## Main and ABA tracks

Enter the `scallop-iccma25` directory and type `cargo build --release --features=iccma` to compile the base package.
This will produce the `scallop_iccma25` binary in the `target/release` directory.
Use this binary for both the main and ABA tracks.


## Dynamic track

Enter the `scallop_ipafair-iccma25` directory and type `cargo build --release` to compile the package dedicated to the dynamic track.
This will produce the `libscallop_ipafair.so` shared library in the `target/release` directory.

Examples of usage are provided in the `resources` directory.
From there, you can uncompress the `iccma25` directory, which contains the material needed to replay the ICCMA'23 dynamic track.
See the `README.md` file in this directory for more information.


## Heuristics track

First, compile the base project in the `scallop-iccma25` directory.
Then, simply execute the `scallop-heuristics-track.sh` script.


## Using an IPASIR-compatible solver

Scallop can take advantage of IPASIR-compatible SAT solvers that are compiled as dynamic libraries.
For the main and dynamic tracks, it is sufficient to set the `IPASIR_LIBRARY` environment variable to the library's path.
To check which solver is in use, add the CLI option `--logging-level=info` options while invoking Scallop.

For more information on the dynamic track, please refer to the `README.md` file in the `iccma25` example in the `resources` folder.


## Thank you

Our warmest thanks to the organizers for all their hard work, and for all that remains to be done.

Jean-Marie, Emmanuel and Jean-Guy.
