#!/bin/bash

scalop="$(dirname 0)/scalop-iccma25/target/release/scalop"
TIMEOUT=55

arg=
input=
problem=

while (test $# -ge 1)
do
    case "$1" in
        -a)
            shift
            arg="-a $1"
            ;;
        -f)
            shift
            input=$1
            ;;
        -p)
            shift
            problem=$1
            ;;
    esac
    shift
done

function wrong_usage {
    echo "ERROR: wrong usage ($1)"
    exit 1
}

(test -z "$input") && wrong_usage "no input file"
(test -z "$problem") && wrong_usage "no problem"

default_value=
(test "$problem" = DC-CO) && default_value=NO
(test "$problem" = DC-ST) && default_value=NO
(test "$problem" = DC-SST) && default_value=NO
(test "$problem" = DC-ID) && default_value=YES
(test "$problem" = DS-PR) && default_value=YES
(test "$problem" = DS-ST) && default_value=YES
(test "$problem" = DS-SST) && default_value=YES
(test -z "$default_value") && wrong_usage "unknown problem"

timeout $TIMEOUT $scalop solve --logging-level off -f "$input" -p "$problem" $arg
(test $? -eq 124) && echo "$default_value" && exit 0
